/*****************************************************************************
*
* Copyright 2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/

/*!*********************************************************************************
*  @file    orbmatchdescriptors_apu_process_desc.hpp
*  @brief   ACF Process Descriptor
***********************************************************************************/

#ifndef ORBMATCHDESCRIPTORSAPUPROCESSDESC_HPP
#define ORBMATCHDESCRIPTORSAPUPROCESSDESC_HPP

#include <acf_process_desc_apu.hpp>
#include "orbmatchdescriptors_graph.hpp"

class OrbMatchDescriptorsApuProcessDesc: public ACF_Process_Desc_APU
{
public:
  void Create()
  {
    Initialize(mGraph, "ORBMATCHDESCRIPTORS");

    SetInputChunkSize(GR_INPUT1_IN, 128, 4);
    SetInputChunkSize(GR_INPUT0_IN, 128, 4);
  }

  OrbMatchDescriptorsGraph mGraph;
};

#endif /* ORBMATCHDESCRIPTORSAPUPROCESSDESC_HPP */
